subroutine t3d1fmIMSLa(k,kwrite,deltat,istept,t,isw,ifill)

!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!c
!c     routine t3d1fm
!c
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!c
!c     first version: october 2nd, 1987
!c
!c     author: rob diependaal
!c     modified: hdh  oct 1997 to f90
!c				 hdh  may 2002: introduce parameters 
!c									l_active, 
!c									l_variable_BM_width
!c
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!c
!c     Computes displacement, velocity, and pressure
!c     in the time domain, based on a 3d-model with two boundary
!c     conditions in the place.
!c     Writes the computed quantities to background memory.
!c
!c     input parameters:
!c        ndim:   dimension of yt
!c        k:    number of time steps
!c        kwrite:  time step from which onwards the quantities
!c                 will be written to memory
!c        deltat:  time step
!c        istept:  =1 -integration step (in the time) is variable
!c                 =2 -integration step is constant
!c        t:    time
!c        !!yt:   contains displacement and velocity
!c        isw:  =1 -extra yx (see common)computations will be done
!c              =0 -no extra computations will be done
!c        ifill:=1 -a and x (see common) will be filled
!c              =0 -a must have been filled and decomposed 
!c                 and x must have been filled previously
!c
!c     output parameters:
!c        t,yt
!c        isw:  =0 -no error has occurred
!c              =2 -error in input parameters
!c              =3 -error in integration in the time
!cm
!c     common parameters in module CochParms:
!c
!c           a		-matrix containing information about
!c                      discretisation in place
!c           alu
!c           blu
!c           asi
!c           aco
!c           d
!c           g		-contains pressure minus mass term
!c           yx		-contains accelleration
!c           x		-contains points along x-axis
!c           yxx
!c           yxlu
!c           rha
!c           epst	-accuracy for integration in the time
!c           deltax	-place step
!c           tref	-reference time
!c           den
!c           rnum
!c           n		-number of discretisation intervals in the place
!c
!c     uses subroutines,
!hd contains: subroutine sum3d, only used by t3d1fm
!hd checking 'common' parameters, that do not require redefinition, 
!hd  nor passing on as parameter
!c
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!include 'link_fnl_static.h'

use LSARG_INT
use CochParms
IMPLICIT none
SAVE

!hd: rearrage alphabetically
real(dbl), dimension(:), allocatable ::  yt, yp
real(dbl), dimension(:), allocatable ::  yx_out
real(dbl) :: a1,a2,a3,a4
real(dbl) :: alpha
real(dbl) :: aux
!real(dbl) :: b1 ,b2 !,dbeta
real(dbl) :: bb1, bb2, bet
real(dbl) :: coef
real(dbl) :: coef2			  !sum
real(dbl) :: coth
real(dbl) :: deltat
real(dbl) :: epssum, epsmod
real(dbl) :: equil
real(dbl) :: gr, grme, gr3d
real(dbl) :: help
real(dbl) :: ht
real(dbl) :: pddh, pdd2h, pdd4h
!real(dbl) :: presed
real(dbl) :: rcond
!real(dbl) :: resist, rmass
!real(dbl) :: stiffn
real(dbl) :: t1, t2, t3, t4, t5, t6, t7, t8, t9
real(dbl) :: t, tend, tout
real(dbl) :: tpddh
real(dbl) :: tt
real(dbl) :: x1, x2			
real(dbl) :: xhelp
real(dbl) :: xx, uu, vv

integer*4 :: i, j, k, l
integer*4 :: ii, i1, jj, k1, l1, l2
integer*4 :: ifill
integer*4 :: iflag
integer*4 :: ios
integer(4) :: irec
integer*4 :: istept
integer*4 :: isw
integer*4 :: jhelp
integer*4 :: khelp, kw
integer*4 :: kwrite
integer*4 :: maxsum, maxmod
integer*4 :: next, nex1
integer*4 :: nn

!local statement functions
!c stiffn(xx,uu,vv)=2d4*exp(-3d-1*xx)
!stiffn(xx,uu,vv)=1d4*exp(-3d-1*xx)
!presed(tt)=3.16d-8*sin(twopi*tt)       !!!!the stimulus
!rmass(xx)=5d-1                         !! amred = amplitude
!b1(xx)= b2(xx)-dbeta(xx)
!hd: hence for constant BM-width, b1=0
coth(xx)=cosh(xx)/sinh(xx)

allocate (yt(ndim), yp(ndim), yx_out(nBM) )

yt=0.
epssum=1.d-2
epsmod=1.d-4
maxsum=1000
maxmod=100

alpha=8d0*rho/(pi*pi*b)*deltax
pddh=pi*deltax/rh
tpddh=par2*pddh
pdd2h=pddh/par2
pdd4h=pdd2h/par2
t4=pi*rl/rh
coef=8d0*rho/pi/rmseff
grme=4d0*rho/rh/rmseff

!c
!c     tests
!c

!if(nd.gt.802) isw=2
if(isw.lt.0 .or. isw.gt.1) isw=2
if(k.le.0 .or. k.lt.kwrite .or. kwrite.le.0) isw=2
!n=nd/2
!if(2*n.ne.nd) isw=2
if(isw.eq.2) return
!
!     initiations
!
if(ifill.eq.0) goto 2000
!hd: otherwise fill a sine table and a cosine table
!hd:  with 4n points over 1 cycle (= 2pi)
do j=0,4*nBM
   asi(j)=sin(dble(j)*pi/par2/dble(nBM))
   aco(j)=cos(dble(j)*pi/par2/dble(nBM))
end do
!
!     fills a, rha and x
!
x(1)=par0
rha(1)=coef*rl
aux=alpha*dbeta(par0)
x(2)=deltax
x1=deltax
t1=log(par2*(cosh(pddh)-par1))
t7=pdd2h*coth(pdd2h)
t5=t7/par2
gr=t1-t4-t7-par1
do j=1,2
   bet=dbeta(dble(j-1)*deltax)
   bb1=b1(dble(j-1)*deltax)
   bb2=b2(dble(j-1)*deltax)
   do i=1,maxmod
      rnum(i,j)=cos(dble(i)*pi*bb2/b)+	&
                cos(dble(i)*pi*bb1/b)
      help=dble(i)*bet/b
      den(i,j)=par1-help*help
      if(abs(den(i,j)).lt.1d-10)then
         den(i,j)=par1
         rnum(i,j)=pi/par2*sin(pi*bb2/bet)
      endif
   enddo !i
end do !j
next=idint(b/dbeta(par0))
nex1=next

call sum3d(1,1,nBM)

a(1,1)=aux*(gr/pi-gr3d+grme/par2*rl*rl)-rmass(par0)
d(1)=abs(a(1,1))
  write(iwrite,*) sngl(a(1,1))
!  print*,aux,gr/pi,gr3d
!  print*,grme/par2*rl*rl, rmass(par0)
!  read(*,*)
rha(2)=coef*(rl-x1)
t2=log(par2*(cosh(tpddh)-par1))
t6=pdd2h*coth(pddh)
gr=t2-t4-t6-t7-5d-1
next=max(nex1,idint(b/dbeta(x1)))

call sum3d(2,1,nBM)

a(2,1)=aux*(gr/pi-gr3d+grme/par2*rl*(rl-x1))
d(2)=abs(a(2,1))
  write(iwrite,*) sngl(a(2,1))
a1=pddh
do i=3,nBM
   x1=x(i-1)+deltax
   x(i)=x1
   rha(i)=coef*(rl-x1)
   a1=a1+pddh
   t8=log(par2*(cosh(a1)-par1))
   gr=t8-t4
   bet=dbeta(x1)
   bb1=b1(x1)
   bb2=b2(x1)
   do ii=1,maxmod
      rnum(ii,i)=cos(dble(ii)*pi*bb2/b)+ &
&               cos(dble(ii)*pi*bb1/b)
      help=dble(ii)*bet/b
      den(ii,i)=par1-help*help
      if(abs(den(ii,i)).lt.1d-10)then
         den(ii,i)=par1
         rnum(ii,i)=pi/par2*sin(pi*bb2/bet)
      endif
   end do !ii
   next=max(nex1,idint(b/bet))
   call sum3d(i,1,nBM)
   a(i,1)=aux*(gr/pi-gr3d+grme/par2*rl*(rl-x1))
   d(i)=abs(a(i,1))
!c    write(iwrite,*)a(i,1)
end do !i

do j=2,nBM
   x2=x(j)
   a4=pi*x2/rh
   aux=alpha*dbeta(x2)
   nex1=idint(b/dbeta(x2))
   do i=1,nBM
      x1=x(i)
      a1=pi*x1/par2/rh
      a2=par2*a1
      a3=par2*a2
      next=max(nex1,idint(b/dbeta(x1)))
      if(iabs(i-j).ge.2)then
         if(i.eq.1)then
            t1=par2*log(par2*(cosh(a4)-par1))
         else
            t1=par2*log(par2*abs(cosh(a2)-cosh(a4)))
         endif
         gr=t1-par2*t4
         call sum3d(i,j,nBM)
         a(i,j)=aux*(gr/pi-gr3d+grme*(rl-x1)*(rl-x2))
      else
         if(iabs(i-j).eq.1)then
            if(i.eq.1)then
               gr=par2*(t1-t4)-t7-par1
               call sum3d(i,j,nBM)
               a(i,j)=aux*(gr/pi-gr3d+grme*rl*(rl-x2))
            else
               t1=par2*log(par2*(abs(cosh(a2)-cosh(a4))))
               t6=a1*coth(a2)
               if(i.lt.j)then
                  t3=par2*x1/deltax*log(sinh(a2+pdd2h)/sinh(a2))
                  t8=(a1+pdd4h)*coth(a2+pdd2h)
               else
                  t3=par2*x1/deltax*log(sinh(a2)/sinh(a2-pdd2h))
                  t8=(a1-pdd4h)*coth(a2-pdd2h)
               endif
               gr=t1+t3-t5-t6-t8-par2*t4-5d-1
               call sum3d(i,j,nBM)
               a(i,j)=aux*(gr/pi-gr3d+grme*(rl-x1)*(rl-x2))
            endif
         else
            t1=log(4d0*(cosh(pddh)-cosh(a3))+par2* &
              (cosh(a3+pddh)+cosh(a3-pddh)-cosh(tpddh)-par1))
            t3=par2*x1/deltax*log(sinh(a2+pdd2h)/sinh(a2-pdd2h))
            t6=a2*coth(a2)
            t8=(a1+pdd4h)*coth(a2+pdd2h)
            t9=(a1-pdd4h)*coth(a2-pdd2h)
            gr=t1+t3-t7-t6-t8-t9-par2*t4-par1
            call sum3d(i,j,nBM)
            a(i,j)=aux*(gr/pi-gr3d+grme*(rl-x1)**2)-rmass(x1)
         endif
      endif
!c        write(iwrite,*)a(i,j)
      d(i)=d(i)+abs(a(i,j))
   end do !i
end do !j
!----------------------------------------------------------------
print *,'Array A is filled now'
!----------------------------------------------------------------

write(9) nBM
write(9)((a(l1,l2),l1=1,nBM),l2=1,nBM)
write(9)(rha(l1),l1=1,nBM)
write(9)(x(l1),l1=1,nBM)
write(9)(d(l1),l1=1,nBM)
!----------------------------------------------------------------
print *,'  ..and parameter writing done.'
!----------------------------------------------------------------
!
!     equilibrates the rows of a
!
do i=1,nBM
   equil=d(i)
   do j=1,nBM
     a(i,j)=a(i,j)/equil
!c  write(iwrite,*)a(i,j)
   end do
end do

!!NOT FOR IMSL
!!     decomposes a in lower and upper triangle
!!
!call dgeco(a,nBM,n-1,ipvt,rcond,work)

!write(9)((a(l1,l2),l1=1,n-1),l2=1,n-1)
!write(9)(ipvt(l1),l1=1,n-1)
!rewind (9)

 2000 &
if(ifill.eq.0)then
   read(9) nn
   read(9)((a(l1,l2),l1=1,nn),l2=1,nn)
   read(9)(rha(l1),l1=1,nn)
   read(9)(x(l1),l1=1,nn)
   read(9)(d(l1),l1=1,nn)
!   read(9)((a(l1,l2),l1=1,nn),l2=1,nn)
!   read(9)(ipvt(l1),l1=1,nn)
endif
ht=deltat
tout=t
k1=k+1
jhelp=0


!
!  do-loop over time variable
! old label 3000
DO  j=1,k1
 if(mod(j,10)==0) then
   if (iwrite > 6) write(*,'(\,a)') '.' 
   if(mod(j,100)==0) then
        write(iwrite,'(a,i7)') ' time step number: ',j
        if (iwrite > 6) print*, ' time step number: ',j
   end if
 end if 
   if(isw.eq.0) goto 3300      !???3200

   gme=resme*yt(nBM1+1)+stifme*yt(1)
   g(1)=resist(par0,yt(2),yt(nBM1+2),l_active)*yt(nBM1+2)+ &
     stiffn(par0,yt(2),yt(nBM1+2))*yt(2)
   rinp=presed(t)
   if(t.le.4d0)rinp=rinp*exp((4d0-t)*(t-4d0)/par2)
   coef2=gme-amred*rinp
   yx(1)=(g(1)-coef2*rha(1))/d(1)
   do i=3,nBM1
      i1=i-1
      xhelp=x(i1)
      g(i1)=resist(xhelp,yt(i),yt(nBM1+i),l_active)*yt(nBM1+i)+ &
        stiffn(xhelp,yt(i),yt(ndim+i))*yt(i)
      yx(i1)=(g(i1)-coef2*rha(i1))/d(i1)
   end do

!   call dgesl(a,nBM,n-1,ipvt,yx,0)
    call lsarg(a, yx, yx_out)
   goto 3300

 3200 isw=1

 3300 &
   jj=j-1
   jhelp=jhelp+1
   if(jj.lt.kwrite.and.jhelp.eq.10)then
      do  kw=11,12
          write(kw,rec=1)x(nBM),deltax,nBM,t,deltat,1
      end do
      do  kw=14,15
          write(kw,rec=1)par0,par0,1,t,deltat,1
      end do 
      write(11,rec=2)(yt(l),l=2,nBM1)
      write(12,rec=2)(yt(l),l=nBM1+2,ndim)
      write(14,rec=2) yt(1)
      write(15,rec=2) yt(nBM1+1)
      jhelp=0
   endif

if(jj < kwrite) then 
   goto 3600
else if(jj == kwrite) then
   khelp=k1-kwrite
   tend=t+(khelp-1)*deltat
   do kw=11,13
      write(kw,rec=1) x(nBM),deltax,nBM,tend,deltat,khelp
   end do  
   do kw=14,15
      write(kw,rec=1) 0.,0.,1,tend,deltat,khelp
   end do
else
    do i=1,nBM
        yp(i)=rmass(x(i))*yx_out(i)+g(i)
    enddo

    irec=j-kwrite
    write(11,rec=irec)(yt(l),l=2,nBM1)
    write(12,rec=irec)(yt(l),l=nBM1+2,ndim)
    write(13,rec=irec)(yp(l),l=1,nBM)
    write(14,rec=irec) yt(1)
    write(15,rec=irec) yt(nBM1+1)
end if

3600 if(j.eq.k1) exit
   iflag=istept
   tout=tout+deltat
   tref=t

3700 call rkf4st(t,tout,yt,ht,ndim,epst,iflag)

   if(iflag.eq.2) write(iwrite,'(a,i2)') ' iflag=', iflag
   if(iflag.eq.2) goto 3700
   if(iflag.eq.3) cycle
   write(iwrite,99999) j
   isw=4
   return
END DO ! 3000 continue

return

5000 write(iwrite,99995)ios
return

99999 format(' error in integration in t-direction, j= ',i5)
99995 format(' t3d1fm: error in rewind statement, ios=',i5)

!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!c
!c     end of routine t3d1fm
!c
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!end
CONTAINS

subroutine sum3d(i_in,j_in,ndim)
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!c
!c     routine sum3d
!c
!cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!c
!c     author: Rob Diependaal
!c
!c     first version: November 6th, 1987
!
!hd modified to contained routine, with adjusted parameters april 2008
!hd, not that parameters used above are not redefined
! 
!cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
use CochParms
IMPLICIT none

real(dbl) :: t1_loc, t2_loc
real(dbl) :: t1sq
real(dbl) :: sum, gamma, term, ratio
real(dbl) :: coeff, coefsq
real(dbl) :: grref

integer(4) :: i_in, j_in, k, m, ndim, ii
integer(4) :: i1, j1
integer(4) :: ind

m=4*ndim
i1=i_in-1
j1=j_in-1
gr3d=par0
grref=gr*rl/pi
   
do 1000 ii=1,maxmod
   t1sq=dble(ii)*pi/b
   t1sq=t1sq*t1sq
   sum=par0
   do 1100 k=0,maxsum
      coeff=(dble(k)+5d-1)*pi/rl
      coefsq=coeff*coeff
      gamma=dsqrt(coefsq+t1sq)
      if(j_in.eq.1)then
         if(i_in.ge.3)then
            ind=mod((2*k+1)*i1,m)
            term=aco(ind)
         else
            if(i_in.eq.2)then
               ind=mod(4*k+2,m)
               term=asi(ind)/par2/coeff/deltax
            else
               ind=mod(2*k+1,m)
               term=asi(ind)/coeff/deltax
            endif
         endif
      else
         if(iabs(i_in-j_in).ge.2)then
            ind=mod((2*k+1)*(i1+j1),m)
            term=aco(ind)
            if(i_in.eq.1)then
               term=par2*term
            else
               ind=mod((2*k+1)*iabs((j_in-i_in)),m)
               term=term+aco(ind)
            endif
         else
            if(iabs(i_in-j_in).eq.1)then
               ind=mod(2*k+1,m)
               t1_loc=asi(ind)/coeff/deltax+aco(ind)
               if(i_in.ne.1)then
                  ind=mod((4*k+2)*i1,m)
                  t2_loc=asi(ind)/coeff/deltax
                  if(i_in.gt.j_in)then
                     ind=mod((2*k+1)*(2*i1-1),m)
                     term=(t1_loc+t2_loc-asi(ind)/coeff/deltax+ &
                          aco(ind))/par2 
                  else
                     ind=mod((2*k+1)*(2*i1+1),m)
                     term=(t1_loc-t2_loc+asi(ind)/coeff/deltax+ &
                          aco(ind))/par2
                  endif
               else
                  term=t1
               endif
            else
               ind=mod(2*k+1,m)
               term=asi(ind)/coeff/deltax
               ind=mod((4*k+2)*i1,m)
               term=term*(1d0+aco(ind))
            endif
         endif
      endif
      term=term/gamma
      sum=sum+term
!    if(abs(term/sum).lt.epssum)goto 1200
    1100 continue
!  write(iwrite,99999)ii,epssum
1200 sum=sum*rnum(ii,i_in)*rnum(ii,j_in)/den(ii,i_in)/den(ii,j_in)
 gr3d=gr3d+sum
 if(ii.gt.next.and.abs(sum/(gr3d+grref)).lt.epsmod) goto 2000
1000 continue

write(iwrite,99998)maxmod,epsmod,i_in,j_in
2000 gr3d=gr3d/rl
ratio=gr3d*pi/gr
if(mod(i_in,8)==0 .and. mod(j_in,8)==0) write(iwrite,99997)ratio,i_in,j_in
return

99997 format(' ratio of 3d correction on 2d term is',d20.13,/ &
            ' for entry',2i12)
99998 format(' mode number',i12,' is still significant', / &
            ' within tolerance',d20.13,' for entry',2i12)
99999 format(' sum does not converge that rapidly, ii=',i12,/ &
            ' within tolerance',d20.13)
!cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!c     end of routine sum3d
!cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
end subroutine sum3d

double precision function dbeta(xin)
use CochParms
IMPLICIT none
real(dbl)::xin
if(l_variable_BM_width) then          !! if statement cannot be used in definition
    dbeta = 8d-2 * exp(5d-2*xin)
else
	dbeta = par1
endif
return
end function dbeta

double precision function b2(xin)
use CochParms
IMPLICIT none
real(dbl)::xin
if(l_variable_BM_width) then          !! if statement cannot be used in definition
    b2 = 85d-2 + 3d-3*xin
else
	b2 = par1
endif
return
end function b2

double precision function b1(xin)
use CochParms
IMPLICIT none
real(dbl)::xin

b1 = b2(xin) - dbeta(xin)
return
end function b1

end     

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!double precision function resist(xx,uu,vv)
!
!use CochParms
!IMPLICIT none
!
!real*8 :: xx, uu, vv
!real(dbl) :: r1, r2
!
!
!if(abs(vv).lt.1d-20)then
!    r1=1d0
!else
!    r1=1d-4*sinh(vv*1d4)/vv    
!endif
!if(abs(vv).gt.170d0)then
!    r2=par0
!else
!    if(l_active) then	
!       r2=par2/cosh(vv*1d6)
!    endif
!endif
!
!resist=25d-1*dsqrt(par2)*(r1-r2)*exp(-15d-2*xx)
!!c  resist=5d0*exp(-15d-2*xx)
!return
!end
      
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
